library(memisc)
library(mestats)
source("panel-envelope.R")
load("mclogit-classd.RData")

newdata.econdim.time.c <- expand.grid(
  econdim = c(-1,1),
  authlib = 0,
  tradmod = 0,
  classd = factor(1:4,labels=mclogit.classd$xlevels$classd),
  Year = seq(from=1975,to=2002,length=21)
  )


newdata.authlib.time.c <- expand.grid(
  authlib = c(-1,1),
  econdim = 0,
  tradmod = 0,
  classd = factor(1:4,labels=mclogit.classd$xlevels$classd),
  Year = seq(from=1975,to=2002,length=21)
  )

newdata.tradmod.time.c <- expand.grid(
  tradmod = c(-1,1),
  authlib = 0,
  econdim = 0,
  classd = factor(1:4,labels=mclogit.classd$xlevels$classd),
  Year = seq(from=1975,to=2002,length=21)
  )

newdata.compare.time.c <- collect(
  "Party A econ. left (-1),\nparty B econ. right (1)"=newdata.econdim.time.c,
  "Party A libertarian (-1),\nparty B authoritarian (1)"=newdata.authlib.time.c,
  "Party A modernist (-1),\nparty B traditionalist (1)"=newdata.tradmod.time.c,
  sourcename="Dimension"
  )

newdata.compare.time.c <- within(newdata.compare.time.c,{
  choice.set <- rep(seq_len(nrow(newdata.compare.time.c) %/% 2),each=2)
  id <- rep(1:2, nrow(newdata.compare.time.c) %/% 2)
  Time <- (Year - min(Year))/(max(Year) - min(Year)) - .5
  })

newdata.compare.time.c <- within(newdata.compare.time.c,{
  link <- predict(mclogit.classd,newdata=newdata.compare.time.c,se=TRUE)
  link.se <- link$se.pred
  link <- link$pred
  pred.resp <- predict(mclogit.classd,newdata=newdata.compare.time.c,type="response",se=TRUE)
  prob <- pred.resp$pred
  se.prob <- pred.resp$se.pred
  # With the mclogit package use these lines:
  #prob <- pred.resp$fit
  #se.prob <- pred.resp$se.fit
  prob.lower <- qnorm(p=0.025,mean=prob,sd=se.prob)
  prob.upper <- qnorm(p=1-0.025,mean=prob,sd=se.prob)
  rm(pred.resp)
})


strip.lop <- vector(mode="list",length=3)
strip.lop[[1]] <- 2.5
strip.lop[[2]] <- "lines"
strip.lop[3] <- list(NULL)
names(strip.lop) <- c("x","unit","data")

xyplot.classd.compare.time.c <- xyplot(
  withLimits(prob,prob.lower,prob.upper)~Year|Dimension,
    groups=classd,
    data=newdata.compare.time.c,
    type="l",
    subset=id==1,
    ylim=c(0.15,0.85),
    ylab="Probability to vote for party A",
    layout=c(3,1),
    aspect=1,
    auto.key=list(points=FALSE,lines=TRUE,columns=2),
    scales=list(alternating=1,tck=c(1,0)),
    panel=function(x,y,...){
            panel.grid(h=-1,v=0,col="gray80")
            panel.envelope(x,y,...)
    },
    lattice.options=list(layout.heights=list(strip=strip.lop)),
    par.settings=list(
      superpose.symbol=list(col="black",pch=15:18,cex=c(.8,.9,.8,1)),
      superpose.line=list(col="black",lty=c(1,2,5,4),lwd=1.5),
      strip.background=list(col="white")
      )
  )

print(xyplot.classd.compare.time.c)



trellis.device(postscript,file="Figure3.eps",
               width=8,height=4.5,horizontal=FALSE)
print(xyplot.classd.compare.time.c)
dev.off()

